%% Do not* change anything in this file %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%*******  define Jacobian matrix for phie ******%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Time derivative by Backward Euler
% F(block1)=((dt)*A_cs-1)cs(t)+(dt)f_cs(cs(t))+cs(t-1)=0
% F(block2)=((dt)*A_ce-1)ce(t)+(dt)f_ce(cs(t))+ce(t-1)=0
% F(block3)=A_phie(ce)*[ce;phie]+f_phie
% F(block4)=A_phis*phis+f_phis+Biapp
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function J_phie =bat_phie_J(y_in)
global eta tem sv porosityNODE dx n_n n_s n_t n_p nr FARADAY RU...
       tPlus alpha_a alpha_c concS_max_n...
       concS_max_p kcon_n kcon_p A_phie jli
conc=y_in(n_n+n_p+n_t+1:n_n+n_p+n_t+n_t);
concS_surf=y_in((n_n+n_p)+n_t+n_t+nr*(n_n+n_p)+1:(n_n+n_p)+n_t+n_t+nr*(n_n+n_p)+n_t);
T=tem(1);
%% define BV equation
jli=zeros(n_t,1);
Jli_phie=zeros(n_t,1);
for k=1:n_n
    i0=kcon_n*(conc(k)^alpha_a)*((concS_max_n-concS_surf(k))^alpha_a)*(concS_surf(k)^alpha_c);
    exp1= exp((alpha_a * FARADAY/( RU * T ))* eta(k));
    exp2= exp(-(alpha_c * FARADAY/( RU * T))* eta(k));
    jli(k)=sv(k)*i0*(exp1-exp2);
    Jli_phie(k)=(-sv(k)*i0*FARADAY/RU/T)*(alpha_a*exp1+alpha_c*exp2);
end
for k=n_n+n_s+1:n_n+n_p+n_s
    i0=kcon_p*(conc(k)^alpha_a)*((concS_max_p-concS_surf(k))^alpha_a)*(concS_surf(k)^alpha_c);
    exp1= exp((alpha_a * FARADAY/( RU * T ))* eta(k));
    exp2= exp(-(alpha_c * FARADAY/( RU * T))* eta(k));
    jli(k)=sv(k)*i0*(exp1-exp2);
    Jli_phie(k)=(-sv(k)*i0*FARADAY/RU/T)*(alpha_a*exp1+alpha_c*exp2);
end 
%% define A_phie matrix
ce=conc.*1.0e-6;
m=exp(0.85 *(( ce.*1000).^1.4 ));
keff=100.0*15.8*(ce.*m).*(porosityNODE.^1.5); 
kd_eff=(keff.*(2*RU*T*(tPlus-1)/FARADAY));
keff_cell(1:n_n+n_s+n_p)=keff;
kd_eff_cell(1:n_n+n_s+n_p)=kd_eff;
% Left Boundary
keff_node(1) = keff_cell(1);
kd_eff_node(1)=kd_eff_cell(1);
for i=1:n_n+n_s+n_p-1
    keff_node(i+1)=(keff_cell(i)*dx(i)+keff_cell(i+1)*dx(i+1))/(dx(i)+dx(i+1));
    kd_eff_node(i+1)=(kd_eff_cell(i)*dx(i)+kd_eff_cell(i+1)*dx(i+1))/(dx(i)+dx(i+1));
end
% Right Boundary
keff_node(n_n+n_p+n_s+1) = keff_node(n_n+n_p+n_s);
kd_eff_node(n_n+n_p+n_s+1) = kd_eff_node(n_n+n_p+n_s);
%%%%%%%%%%%%%%% finite volume matrix %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for i=1;
    A_phie(i,i)=-keff_node(i+1)*2/(dx(i)+dx(i+1));
    A_phie(i,i+1)=keff_node(i+1)*2/(dx(i)+dx(i+1));   
end
for i=2:n_n+n_s+n_p-1
    left=keff_node(i)*2/(dx(i)+dx(i-1));
    right=keff_node(i+1)*2/(dx(i)+dx(i+1));    
    A_phie(i,i-1)=left;
    A_phie(i,i)=-(left+right);
    A_phie(i,i+1)=right;
end
for i=n_n+n_s+n_p;   
    A_phie(i,i-1)=keff_node(i)*2/(dx(i)+dx(i-1));
    A_phie(i,i)=-keff_node(i)*2/(dx(i)+dx(i-1));
end
f_phie=(Jli_phie'.*dx)';
J_phie=A_phie+spdiags(f_phie,0,length(f_phie),length(f_phie));
